import misc.Debug;
import types.DataClass;

class SlidingWindowSampler extends sampling.BaseSampler {


    DataClass   sender_send_Window;
    DataClass   sender_receive_Window;
    DataClass   receiver_send_Window;
    DataClass   receiver_receive_Window;
    boolean     m_bForceRedisplay;

    public SlidingWindowSampler() {
        super( 100, 100, Global.watcher, "SlidingWindowSampler");
        resume();
        // Make a copy of the current sender windows
        try {
            sender_send_Window = (DataClass)Global.sender.protocol().sendWindow.clone();
            sender_receive_Window = (DataClass)Global.sender.protocol().receiveWindow.clone();
        }
        catch (CloneNotSupportedException e) {;}
        // Make a copy of the current receiver windows
        try {
            receiver_send_Window = (DataClass)Global.receiver.protocol().sendWindow.clone();
            receiver_receive_Window = (DataClass)Global.receiver.protocol().receiveWindow.clone();
        }
        catch (CloneNotSupportedException e) {;}
        m_bForceRedisplay = true;
    }

    public void do_poll() {
    }

    public void do_display() {
        // compare current windows with old ones
        // and redisplay, if a change occured
//        synchronized (Global.sender) {
            if (!sender_send_Window.equals(Global.sender.protocol().sendWindow)||m_bForceRedisplay) {
                ((SenderPanel)Global.sender.panel()).redisplay(Global.sender.protocol().sendWindow,
                                                               Global.sender.protocol().receiveWindow);
                ((ChannelPanel)Global.channel.panel()).myUpdate();
                // Make a copy of the current windows
                try {
                    sender_send_Window = (DataClass)Global.sender.protocol().sendWindow.clone();
                    sender_receive_Window = (DataClass)Global.sender.protocol().receiveWindow.clone();
                }
                catch (CloneNotSupportedException e) {;}
            }
//        }
//         synchronized (Global.receiver) {
            if (!receiver_receive_Window.equals(Global.receiver.protocol().receiveWindow)||m_bForceRedisplay) {
                ((ReceiverPanel)Global.receiver.panel()).redisplay(Global.receiver.protocol().sendWindow,
                                                                   Global.receiver.protocol().receiveWindow);
                ((ChannelPanel)Global.channel.panel()).myUpdate();
                // Make a copy of the current windows
                try {
                    receiver_send_Window = (DataClass)Global.receiver.protocol().sendWindow.clone();
                    receiver_receive_Window = (DataClass)Global.receiver.protocol().receiveWindow.clone();
                }
                catch (CloneNotSupportedException e) {;}
            }
//        }
        m_bForceRedisplay = false;
    }
}

